import React, { useState, useEffect } from "react";
import axios from "axios";
import "../styles/login.css";

export default function OTPPage({ nationalId, onLoginSuccess }) {
  const [otp, setOtp] = useState("");
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const [timeLeft, setTimeLeft] = useState(300); // 5 minutes in seconds
  const [canResend, setCanResend] = useState(false);

  useEffect(() => {
    // Start the timer
    if (timeLeft > 0) {
      const timer = setInterval(() => {
        setTimeLeft(prev => prev - 1);
      }, 1000);

      return () => clearInterval(timer);
    } else {
      setCanResend(true);
    }
  }, [timeLeft]);

  const formatTime = (seconds) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins}:${secs.toString().padStart(2, '0')}`;
  };

  const handleResendOTP = async () => {
    if (!canResend) return;
    
    setError("");
    setLoading(true);
    try {
      await axios.post("http://localhost:5000/api/request-otp", { nationalId });
      setTimeLeft(300); // Reset timer to 5 minutes
      setCanResend(false);
    } catch (err) {
      setError(err.response?.data?.message || "Failed to resend OTP");
    }
    setLoading(false);
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setError("");
    setLoading(true);
    try {
      const res = await axios.post("http://localhost:5000/api/verify-otp", {
        nationalId,
        otp,
      });
      localStorage.setItem("token", res.data.token);
      // onLoginSuccess();
      localStorage.setItem("isAuthenticated", "true");
      onLoginSuccess();
    } catch (err) {
      setError(err.response?.data?.message || "Invalid OTP");
    }
    setLoading(false);
  };

  return (
    <div
      className="login-page"
      style={{ backgroundImage: "url('/login-bg.jpg')" }}
    >
      <div className="login-box">
        <img src="/MIPLOGO.png" alt="Misr Italia Properties" />
        <p className="subtitle">Enter OTP</p>

        <form onSubmit={handleSubmit} className="login-form">
          <label>OTP Code</label>
          <input
            type="text"
            value={otp}
            onChange={(e) => setOtp(e.target.value)}
            placeholder="Enter OTP"
            required
          />
          {error && <p className="error-text">{error}</p>}
          <button type="submit" disabled={loading} className="login-button">
            {loading ? "Verifying..." : "Verify"}
          </button>

          <div className="otp-timer">
            <p>Time remaining: {formatTime(timeLeft)}</p>
            <button
              type="button"
              onClick={handleResendOTP}
              disabled={!canResend || loading}
              className={`resend-button ${!canResend ? 'disabled' : ''}`}
            >
              Send Again
            </button>
          </div>
        </form>

        <p className="login-footer">
          Did not receive OTP? <span>Call 16519</span>
        </p>
      </div>
    </div>
  );
}